/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile.collector;

import committee.nova.mods.avaritia.api.common.item.BaseItemStackHandler;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.common.tile.collector.CollectorTier;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.util.ItemUtils;
import committee.nova.mods.avaritia.util.lang.Localizable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseNeutronCollectorTile
extends BaseInventoryTileEntity
implements MenuProvider {
    public final BaseItemStackHandler inventory;
    public SimpleContainerData data = new SimpleContainerData(1);
    private int progress;
    private CollectorTier tier;

    public BaseNeutronCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_collector_tile.get(), pos, state);
        this.inventory = BaseNeutronCollectorTile.createInventoryHandler(null);
        if (state.m_60713_((Block)ModBlocks.neutron_collector.get())) {
            this.tier = CollectorTier.DEFAULT;
        } else if (state.m_60713_((Block)ModBlocks.dense_neutron_collector.get())) {
            this.tier = CollectorTier.DENSE;
        } else if (state.m_60713_((Block)ModBlocks.denser_neutron_collector.get())) {
            this.tier = CollectorTier.DENSER;
        } else if (state.m_60713_((Block)ModBlocks.densest_neutron_collector.get())) {
            this.tier = CollectorTier.DENSEST;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BaseNeutronCollectorTile tile) {
        if (level.f_46443_) {
            return;
        }
        if (tile.canWork()) {
            ItemStack result = tile.inventory.getStackInSlot(0);
            ItemStack stack = new ItemStack((ItemLike)tile.tier.production);
            ++tile.progress;
            tile.data.m_8050_(0, tile.progress);
            if (tile.progress >= tile.tier.production_ticks) {
                if (result.m_41619_()) {
                    tile.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else if (result.m_150930_(tile.tier.production) && result.m_41613_() < 64) {
                    tile.inventory.setStackInSlot(0, ItemUtils.grow(result, 1));
                }
                tile.progress = 0;
                tile.setChangedAndDispatch();
            }
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(1, onContentsChanged);
        inventory.setOutputSlots(0);
        return inventory;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
    }

    @Override
    @NotNull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    protected boolean canWork() {
        return this.inventory.getStackInSlot(0).m_41619_() || this.inventory.getStackInSlot(0).m_41613_() < 64;
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("container." + this.tier.name).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return NeutronCollectorMenu.create(windowId, playerInventory, this.inventory, this.m_58899_(), (ContainerData)this.data);
    }

    public CollectorTier getTier() {
        return this.tier;
    }

    public void setTier(CollectorTier tier) {
        this.tier = tier;
    }

    public int getProductionTicks() {
        return this.tier.production_ticks;
    }

    public Item getProduction() {
        return this.tier.production;
    }
}

